VERSION 5.00
Begin VB.Form frmExtRefScan 
   Caption         =   "Form1"
   ClientHeight    =   3600
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5250
   LinkTopic       =   "Form1"
   ScaleHeight     =   3600
   ScaleWidth      =   5250
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtReadings 
      Height          =   1695
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   3
      Top             =   1560
      Width           =   2415
   End
   Begin VB.TextBox txtRefJunction 
      Height          =   495
      Left            =   3720
      TabIndex        =   1
      Text            =   "Text1"
      Top             =   240
      Width           =   1095
   End
   Begin VB.CommandButton cmdScan 
      Caption         =   "Start Scan"
      Height          =   615
      Left            =   3240
      TabIndex        =   0
      Top             =   2640
      Width           =   1695
   End
   Begin VB.Label Label2 
      Caption         =   "Thermocouple Temperature"
      Height          =   375
      Left            =   120
      TabIndex        =   4
      Top             =   1080
      Width           =   2655
   End
   Begin VB.Label Label1 
      Caption         =   "Ref Junction Temperature, C:"
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   360
      Width           =   2655
   End
End
Attribute VB_Name = "frmExtRefScan"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'' """""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
''    Copyright  2002 Agilent Technologies Inc. All rights
''    reserved.
''
'' You have a royalty-free right to use, modify, reproduce and distribute
'' the Sample Application Files (and/or any modified version) in any way
'' you find useful, provided that you agree that Agilent has no
'' warranty,  obligations or liability for any Sample Application Files.
''
'' Agilent Technologies provides programming examples for illustration only,
'' This sample program assumes that you are familiar with the programming
'' language being demonstrated and the tools used to create and debug
'' procedures. Agilent support engineers can help explain the
'' functionality of Agilent software components and associated
'' commands, but they will not modify these samples to provide added
'' functionality or construct procedures to meet your specific needs.
'' """"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
'
' This code implements a simple scan with the 34970A using the Agilent IO objects
' that is part of the Agilent ISDK for Visual Basic. It demontrates using
' an external temperature junction reference to make thermocouple measurements.
'
' The scan uses channel 101 as a thermocouple junction reference. Channel 101
' has a 10k ohm thermistorm to make the temperature measurement. This temperature
' is displayed on the upper right text box.
'
' channel 102 and 103 have a thermocouple that is measured using the external
' junction reference temperature.
'
' This code has a reference to the Agilent IO objects. To use the IO object in
' another Visual Basic project set the reference in the Project/References menu
' to 'Agilent I/O manager'
'


Private Sub cmdScan_Click()
' initialize io object set the functions and then scan
    Dim readings() As Double
    Dim result As String
    Dim scanList As String
    Dim DAQ As AgtIOServer
    Dim io_mgr As AgilentIOUtilsLib.AgtIOManager
    Dim i As Long

    Set io_mgr = New AgtIOManager
    Set DAQ = io_mgr.ConnectToInstrument("GPIB0::9")

    With DAQ
        ' Stop any ongoing scan
        .Output "Abort"
        ' reset instrument
        .Output "*RST"

        ' configure First channel of first module to thermistor 10k ohm
        ' This will measure the reference Junction temperature
        .Output "Conf:Temp THER,10000,(@101);:Unit:Temp C,(@101)"

        ' configure the channels for the thermocouple
        .Output "Conf:Temp TC,J,(@103);:Unit:Temp C,(@103)"
        .Output "Conf:Temp TC,T,(@102);:Unit:Temp C,(@102)"

        ' configure any other channels
        .Output "Conf:volt:DC 10,(@111:113);:Volt:DC:NPLC 1,(@111:113)"

        ' set the scan list for all channels including the reference junction temperature
        scanList = "(@101,102,103,111:113)"
        .Output "Rout:Scan " & scanList

        ' Set the thermocouple channel to the external reference
        ' note only the thermocouples are in the scan list
        scanList = "(@102,103)"
        .Output "Temp:Tran:TC:RJun:Type EXT," & scanList

        ' initialize and wait for the scan to complete
        .Output "INIT"
        .Output "*OPC?"
        .Enter result

        ' Get the data from the instrument
        .Output "Fetch?"
        .Enter readings
    End With

    txtRefJunction.Text = readings(0)
    With txtReadings
        .Text = ""
        .SelText = Now & vbCrLf
        For i = 1 To UBound(readings)
            .SelText = readings(i) & vbCrLf
        Next i
    End With

End Sub


